#pragma rtGlobals=1		// Use modern global access method.
#pragma version=3.1

// ********* Window Filters ***********

Function WindowFilterReset()
	WindowFiltersSetupDesign()
	SetAxis/A/Z bottom			// in case user set a manual X axis range
	Execute "wfComputeButton(\"\")"
End

Function ButtonOtherWindowFilters(ctrlName) : ButtonControl
	String ctrlName

	DoWindow/F WMWindowFilterDesign
	if( V_Flag==0 )
		WindowFiltersSetupDesign()
	endif
End

Function WindowFiltersSetupDesign()

	NVAR fs= root:Packages:WM_IFDL:fs

	String dfSav= Set_IFDL_DataFolder()
	
	Variable lphp=NumVarOrDefault("wf_lphp",1)
	Variable nt=NumVarOrDefault("wf_n",41)
	Variable b1end=NumVarOrDefault("wf_b1e",0.3)
	Variable b2start=NumVarOrDefault("wf_b2s",0.4)
	Variable wtype=NumVarOrDefault("wf_wtyp",1)

	// Create the globals
	Variable/G wf_lphp=lphp
	Variable/G wf_n=nt
	Variable/G wf_b1e=b1end
	Variable/G wf_b2s=b2start
	Variable/G wf_wtyp=wtype

	// scale the saved normalized frequencies for the SetVariable controls
	Variable/G wf_b1e_fs= b1end * fs
	Variable/G wf_b2s_fs= b2start * fs

	SetDataFolder dfSav

	OtherWindowFiltersUpdate()
	CreateWindowFiltersDesign()
	OtherWindowFiltersUpdate()			// set the control limits, too.
End

// update waves that show the MPR 2 Band design parameters
// This is called whenever any parameters change.
Function OtherWindowFiltersUpdate()

	NVAR fs= root:Packages:WM_IFDL:fs

	String dfSav= Set_IFDL_DataFolder()
	Variable lphp= NumVarOrDefault("wf_lphp",1)
	Variable nt= NumVarOrDefault("wf_n",41)
	Variable wtype= NumVarOrDefault("wf_wtyp",1)

	Variable b1endFs= NumVarOrDefault("wf_b1e_fs",0.3 * fs)
	Variable b2startFs=NumVarOrDefault("wf_b2s_fs",0.4 * fs)

	// Save the normalized frequencies in case the user changes sampling frequency
	Variable/G wf_b1e= b1endFs/fs
	Variable/G wf_b2s= b2startFs/fs

	Variable isLowPass= lphp == 1
	
	// Passband and stop band response pair, linear response
	Make/O wf_responseX = {0,b1endFs,NaN,b2startFs,fs*0.5}
	Make/O wf_response  = {isLowPass,isLowPass,NaN,!isLowPass,!isLowPass}	// updated by DesiredFromActualResponse
	Variable eps=abs(b1EndFs - b2startFS)/8
	DesiredFromActualResponse(wf_response,"WMWindowFilterDesign",b1endFs,b2startFs,0,0,isLowPass,eps)
	
	// transition region waves
	Make/O     wf_transitionX = {wf_responseX[1],wf_responseX[3]}
	Make/O/N=2 wf_transitionPlus =  max(wf_response[0],wf_response[3])
	Make/O/N=2 wf_transitionMinus = min(wf_response[0],wf_response[3])

	DoWindow WMWindowFilterDesign
	if( V_Flag == 1 ) // don't allow the end of the pass band to exceed the start of the stop band
		ControlInfo/W=WMWindowFilterDesign wf_b1e
		Variable band1End= V_Value
		ControlInfo/W=WMWindowFilterDesign wf_b2s
		Variable band2Start= V_Value

		Variable df=  NiceNumber(fs/200)
		// don't let band 1 end after the start of band 2
		Variable end1Max= max(band1End,band2Start)
		end1Max= limit(end1Max,0,fs/2)
		
		SetVariable wf_b1e,limits={0,end1Max,df},win=WMWindowFilterDesign
		
		// don't let band 2 start before the end of band 1
		Variable start2Min= min(band1End,band2Start)
		start2Min= limit(start2Min,0, fs/2)
		SetVariable wf_b2s,limits={start2Min,fs/2,df},win=WMWindowFilterDesign

		ControlUpdate/A/W=WMWindowFilterDesign
	endif
	SetDataFolder dfSav
End

Function CreateWindowFiltersDesign()

	if( DesignGraph("WMWindowFilterDesign","Window Filter Design") )
		return 1	// already existed, don't reset the graph settings.
	endif

	NVAR fs= root:Packages:WM_IFDL:fs
	NVAR lphp= root:Packages:WM_IFDL:wf_lphp	// see PopupMenu wf_lphp, below
	String typeList= "low pass;high pass"
	String popMenuValue= GetStrFromList(typeList, lphp, ";")
	Variable df= NiceNumber(fs/200)	// 1,2,5 increment for SetVariable controls

	NVAR wType= root:Packages:WM_IFDL:wf_wtyp	// see PopupMenu wf_wtyp, below
	String windowTypes="Hanning;Parzen;Welch;Kaiser[1];rectangular"
	String popMenuWindowValue= GetStrFromList(windowTypes, wType, ";")

	String dfSav= Set_IFDL_DataFolder()
	AppendToGraph/L=responseLeft wf_transitionPlus,wf_transitionMinus vs wf_transitionX
	AppendToGraph/L=responseLeft wf_response vs wf_responseX
	SetDataFolder dfSav

	ModifyGraph mode(wf_transitionPlus)=7
	ModifyGraph lSize(wf_transitionPlus)=0,lSize(wf_transitionMinus)=0
	ModifyGraph rgb(wf_transitionPlus)=(56797,56797,56797)
	ModifyGraph hbFill(wf_transitionPlus)=2
	ModifyGraph toMode(wf_transitionPlus)=1

	ModifyGraph lblPos(responseLeft)=60
	ModifyGraph freePos(responseLeft)={0,bottom}
	ModifyGraph margin(left)=67
	ModifyGraph minor(bottom)=1
	SetAxis/A/N=1 responseLeft
	Label responseLeft "response (dB)"
	ControlBar 63
	SetVariable wf_b1e,pos={11,3},size={211,17},proc=MPR_wf,title="End of First Band"
	SetVariable wf_b1e,limits={0,fs/2,df},value= root:Packages:WM_IFDL:wf_b1e_fs
	SetVariable wf_b2s,pos={237,3},size={245,17},proc=MPR_wf,title="Start of Second Band"
	SetVariable wf_b2s,limits={0,fs/2,df},value= root:Packages:WM_IFDL:wf_b2s_fs
	PopupMenu wf_lphp,pos={8,22},size={158,19},proc=wfLowHighPopup,title="Filter Type"
	PopupMenu wf_lphp,mode=lphp,popvalue=popMenuValue,value=#"\"low pass;high pass\""
	SetVariable wf_n,pos={11,43},size={211,17},title="Number of Terms"
	SetVariable wf_n,limits={5,9999,1},value= root:Packages:WM_IFDL:wf_n
	PopupMenu wf_wtyp,pos={237,22},size={160,19},proc=wfWindowPopup,title="Window"
	PopupMenu wf_wtyp,mode=wType,popvalue=popMenuWindowValue,value= #"\"Hanning;Parzen;Welch;Kaiser[1];rectangular\""
	CheckBox dbCheck,pos={241,44},size={110,15},proc=wfdbcheck,title="dB Response",value=1
	Button wfCompute,pos={370,43},size={109,17},proc=wfComputeButton,title="Compute Filter"
	Textbox/N=wfLegend/X=0.99/Y=34.30 ""
	wfLegend()
	SetWindow WMWindowFilterDesign, hook=designHook
	return 0
End

Function wfLowHighPopup(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum	// which item is currently selected (1-based)
	String popStr		// contents of current popup item as string

	NVAR lphp= root:Packages:WM_IFDL:wf_lphp
	lphp= popNum
	OtherWindowFiltersUpdate()
End

Function wfWindowPopup(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum	// which item is currently selected (1-based)
	String popStr		// contents of current popup item as string

	NVAR wtype= root:Packages:WM_IFDL:wf_wtyp
	wtype= popNum
	OtherWindowFiltersUpdate()
End


Function MPR_wf(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName

	OtherWindowFiltersUpdate()
End

Function wfdbcheck(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked

	dBCheck(checked)
	OtherWindowFiltersUpdate()
	wfLegend()
End

Function wfLegend()
	DesignLegend("WMWindowFilterDesign","wf","wfLegend")
End


Function ParzenOrWelch(w,isWelch)
	wave w
	Variable isWelch
	
	Variable N=numpnts(w),tmp

	Variable sumsqr=0,jj=0
	do
		tmp=(jj-0.5*(N-1))/(0.5*(N+1))
		if(isWelch)
			tmp=1-tmp^2
		else
			tmp=1-abs(tmp)
		endif
		sumsqr+=tmp^2
		w[jj] *= tmp
		jj+=1
	while(jj<N)
	return sumsqr/N
end

Function Parzen(w)
	wave w

	return ParzenOrWelch(w,0)
End

Function Welch(w)
	wave w

	return ParzenOrWelch(w,1)
End

Function Kaiser(w,beta)
	wave w
	Variable beta
	
	Variable N=numpnts(w),tmp
	Variable IBeta=BessI(0,beta),NM1=(N-1)/2

	Variable sumsqr=0,jj=0
	do
		tmp=BessI(0,beta*sqrt(1-((jj-NM1)/NM1)^2))/IBeta
		sumsqr+=tmp^2
		w[jj] *= tmp
		jj+=1
	while(jj<N)
	return sumsqr/N
end

Proc wfComputeButton(ctrlName) : ButtonControl
	String ctrlName

	Variable debug= strsearch(ctrlName,"Debug",0) >= 0	// change the name of the Compute Filter button
	Silent 1;PauseUpdate // Window Filter...
	Variable fs= root:Packages:WM_IFDL:fs

	String dfSav= Set_IFDL_DataFolder()
	Variable lphp= wf_lphp
	Variable b1endFs= wf_b1e_fs
	Variable b2startFs= wf_b2s_fs
	Variable wtype= wf_wtyp
	Variable nt= wf_n
	SetDataFolder dfSav

	Variable b1end= b1endFs / fs
	Variable b2start= b2startFs / fs

	if( ChkFreq(b1end,b2start,0,0) )
		abort
	endif

	String designTypes="Hanning window ;Parzen window ;Welch window ;Kaiser(1) window ;Rectangular window " // notice trailing spaces
	String filterNames="HannWindow;ParzenWindow;WelchWindow;KaiserWindow;RectWindow"

	Set_IFDL_DataFolder()
	String/G designTypeName= "window method; two band; "+GetStrFromList(designTypes, wType+1, ";")
	String/G proposedFilterName= GetStrFromList(filterNames, wType+1, ";")
	Variable/G designFlags=0x3
	Variable islp= lphp==1
	
	Make/O bandInfo={islp,0,b1end*fs,!islp,b2start*fs,0.5*fs}

	Variable n=8*CeilPwr2(nt)
	Make/O/C/N=(n+1) resp_tmp1
	SetScale x,0,0.5,resp_tmp1
	resp_tmp1=cmplx(REdge(x,(b2start+b1end)/2,0.4*(b2start-b1end),!islp),0)
	if( debug )
		Duplicate/O resp_tmp1 responseFreqDomain
	endif
	IFFT resp_tmp1
	if( debug )
		Duplicate/O resp_tmp1 responseTimeDomain
	endif
	Rotate floor(nt/2),resp_tmp1
	
	String cwave=dfSav+"coefs"
	Make/O/N=(nt) $cwave
	SetScale/P x,0,1,$cwave
	$cwave=root:Packages:WM_IFDL:resp_tmp1[p]
	KillWaves resp_tmp1
	if( debug )
		Duplicate/O $cwave coefsBeforeWindow
		Duplicate/O $cwave windowShape
		windowShape= 1
		ApplyWindow(windowShape,wtype)
	endif

	ApplyWindow($cwave,wtype)
	Variable nfreq
	if(islp)
		nfreq=0
		proposedFilterName += "LP"
	else
		nfreq=0.5
		proposedFilterName += "HP"
	endif
	SetDataFolder dfSav
	
	Variable sum= CalcNormalizingResponse(coefs,nfreq)
	coefs /= sum		// normalize response to unity

	StdCoefsTreatmentNoShowResults(0x1f,1)

	DoWindow/F WMWindowFilterDesign
	CheckDisplayed/W=WMWindowFilterDesign root:Packages:WM_IFDL:coefsMag,root:Packages:WM_IFDL:coefsDbMag
	if( V_Flag == 0 )
		ControlInfo/W=WMWindowFilterDesign dbCheck
		Variable wantDB= V_value
		Append/L=responseLeft $responseName(wantDB,1)
		String traceName= responseName(wantDB,0)
		ModifyGraph rgb($traceName)=(0,0,65535)
		ReorderTraces wf_response, {$traceName}	// put actual response under desired response
	endif
	AppendPassDetails("detailsLeft",root:Packages:WM_IFDL:magPassDetails)	// appends /L=detailsLeft
	OtherWindowFiltersUpdate()
	AutoApplyFilter()
	wfLegend()
end

Function ApplyWindow(wv,wtype)
	Wave wv
	Variable wtype	// from prompt popup, "Hanning;Parzen;Welch;Kaiser[1];rectangular"
	
	String pfn
	if(wtype==1)
		Hanning wv
	else
		if(wtype==2)
			Parzen(wv)
		else
			if(wtype==3)
				Welch(wv)
			else
				if(wtype==4)
					Kaiser(wv,1)
				endif
			endif
		endif
	endif
End